/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ***********************************************************************
   *                                                                     *
   * regx10.h                                                            *
   * Christian Zurhorst, BID R&D, 12. Sep. 1997                          *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/


#include <xregxdir.h>


#define MERGE_FREEACCESS(cmd)        CMD_MERGE (CMDG_FREEACCESS, cmd)


/* 05\h .. 0f\h port sensitive calls */
/* these calls are identical for each port but the return port dependend
   data like licensing information */

#define CMDM_LICENSE_GET        0x05
#define CMD_LICENSE_GET            MERGE_FREEACCESS (CMDM_LICENSE_GET)
#define IN_LICENSE_GET             0
#define OUT_LICENSE_GET            12

#define CMDM_LICENSE_SET        0x06
#define CMD_LICENSE_SET            MERGE_FREEACCESS (CMDM_LICENSE_SET)
#define IN_LICENSE_SET            12
#define OUT_LICENSE_SET             0

#define CMDM_ERRPAR_GET            0x07
#define CMD_ERRPAR_GET            MERGE_FREEACCESS (CMDM_ERRPAR_GET)
#define IN_ERRPAR_GET             0
#define OUT_ERRPAR_GET            20

#define CMDM_RESET_CHECK        0x08
#define CMD_RESET_CHECK            MERGE_FREEACCESS (CMDM_RESET_CHECK)
#define IN_RESET_CHECK            0
#define OUT_RESET_CHECK            4

/* 10\h .. 1f\h serial port communication */
/* these calls are only accessible when connected by serial port */

#define CMDM_SER_BAUDRATE_SET        0x10
#define CMD_SER_BAUDRATE_SET        MERGE_FREEACCESS (CMDM_SER_BAUDRATE_SET)
#define IN_SER_BAUDRATE_SET         4
#define OUT_SER_BAUDRATE_SET         0

/* 20\h .. 2f\h parallel port communication */
/* these calls are only accessible when connected by parallel port */


/* 30\h .. 3f\h PCI port communication */
/* these calls are only accessible when connected by PCI port */


/* 40\h .. 4f\h USB port communication */
/* these calls are only accessible when connected by LAN port */

/* 50\h .. 5f\h LAN port communication */
/* these calls are only accessible when connected by LAN port */

/* entries up tp 7f\h are reserved for port specific functions */

#define CMDM_UNLOCK_ALL         0x80
#define CMD_UNLOCK_ALL          MERGE_FREEACCESS (CMDM_UNLOCK_ALL)
#define IN_UNLOCK_ALL           0
#define OUT_UNLOCK_ALL          0

#define CMDM_ISLOCKED           0x81
#define CMD_ISLOCKED            MERGE_FREEACCESS (CMDM_ISLOCKED)
#define IN_ISLOCKED             1
#define OUT_ISLOCKED            8

#define CMDM_INIT_DATABASE      0x82
#define CMD_INIT_DATABASE       MERGE_FREEACCESS (CMDM_INIT_DATABASE)
#define IN_INIT_DATABASE        0
#define OUT_INIT_DATABASE       0

/* direct register write */
#define CMDM_REGISTER_READ      0x83
#define CMD_REGISTER_READ       MERGE_FREEACCESS (CMDM_REGISTER_READ)
#define IN_REGISTER_READ        5
#define OUT_REGISTER_READ       4

#define CMDM_PING            0x90
#define CMD_PING            MERGE_FREEACCESS (CMDM_PING)
#define IN_PING                0
#define OUT_PING            0

/* reading the version information out of the hardware */
#define CMDM_FREEVERSION_GET        0x91
#define CMD_FREEVERSION_GET        MERGE_FREEACCESS (CMDM_FREEVERSION_GET)
#define IN_FREEVERSION_GET        1
#define OUT_FREEVERSION_GET        BX_LENGTH_NEGOTIATE

#define CMDM_DATECODE_GET        0x92
#define CMD_DATECODE_GET        MERGE_FREEACCESS (CMDM_DATECODE_GET)
#define IN_DATECODE_GET            1
#define OUT_DATECODE_GET        4

#if 1
/* do a core switch .. */
#define CMDM_CORE_SWITCH            0xa0
#define CMD_CORE_SWITCH             MERGE_FREEACCESS (CMDM_CORE_SWITCH)
#define IN_CORE_SWITCH              0
#define OUT_CORE_SWITCH             0

/* reset functions */
#define CMDM_BOARD_RESET            0xa1
#define CMD_BOARD_RESET             MERGE_FREEACCESS (CMDM_BOARD_RESET)
#define IN_BOARD_RESET              0
#define OUT_BOARD_RESET             0

#define CMDM_RUN_RAM                0xa3
#define CMD_RUN_RAM                 MERGE_FREEACCESS (CMDM_RUN_RAM)
#define IN_RUN_RAM                  5
#define OUT_RUN_RAM                 0


#define CMDM_DISCARD_FIRMWARE           0xa8
#define CMD_DISCARD_FIRMWARE            MERGE_FREEACCESS (CMDM_DISCARD_FIRMWARE)
#define IN_DISCARD_FIRMWARE             40
#define OUT_DISCARD_FIRMWARE            0

#endif

#define CMDM_FLASH_PROG                 0xa8
#define CMD_FLASH_PROG                  MERGE_FREEACCESS (CMDM_FLASH_PROG)
#define IN_FLASH_PROG                   BX_LENGTH_NEGOTIATE
#define OUT_FLASH_PROG                  0

/* mailbox register read and write */
#define CMDM_MAILBOX_READ               0xb0
#define CMD_MAILBOX_READ                MERGE_FREEACCESS (CMDM_MAILBOX_READ)
#define IN_MAILBOX_READ                 0
#define OUT_MAILBOX_READ                5 /* 1 long, 1byte */

#define CMDM_MAILBOX_WRITE              0xb1
#define CMD_MAILBOX_WRITE               MERGE_FREEACCESS (CMDM_MAILBOX_WRITE)
#define IN_MAILBOX_WRITE                4 /* 1 long */
#define OUT_MAILBOX_WRITE               1 /* 1 byte */
/* entries f0\h to ff\h are for debugging purposes */

#define IN_DBG_SECTION             1

#define CMDM_DBG_SECTION_SET        0xf0
#define CMD_DBG_SECTION_SET        MERGE_FREEACCESS (CMDM_DBG_SECTION_SET)
#define IN_DBG_SECTION_SET        IN_DBG_SECTION
#define OUT_DBG_SECTION_SET         0

#define CMDM_DBG_SECTION_CLEAR        0xf1
#define CMD_DBG_SECTION_CLEAR        MERGE_FREEACCESS (CMDM_DBG_SECTION_CLEAR)
#define IN_DBG_SECTION_CLEAR        IN_DBG_SECTION
#define OUT_DBG_SECTION_CLEAR         0

#define CMDM_DBG_SECTION_SETALL        0xf2
#define CMD_DBG_SECTION_SETALL        MERGE_FREEACCESS (CMDM_DBG_SECTION_SETALL)
#define IN_DBG_SECTION_SETALL         0
#define OUT_DBG_SECTION_SETALL         0

#define CMDM_DBG_SECTION_CLEARALL    0xf3
#define CMD_DBG_SECTION_CLEARALL    MERGE_FREEACCESS (CMDM_DBG_SECTION_CLEARALL)
#define IN_DBG_SECTION_CLEARALL         0
#define OUT_DBG_SECTION_CLEARALL            0

#define CMDM_DBG_SECTION_GET        0xf4
#define CMD_DBG_SECTION_GET        MERGE_FREEACCESS (CMDM_DBG_SECTION_GET)
#define IN_DBG_SECTION_GET        IN_DBG_SECTION
#define OUT_DBG_SECTION_GET         1

#define CMDM_FUNLONG                    0xfe
#define CMD_FUNLONG                     MERGE_FREEACCESS (CMDM_FUNLONG)
#define IN_FUNLONG                       4
#define OUT_FUNLONG                      0

#define CMDM_UNKNOWN_CMD        0xff
#define CMD_UNKNOWN_CMD            MERGE_FREEACCESS (CMDM_UNKNOWN_CMD)
#define IN_UNKNOWN_CMD             4
#define OUT_UNKNOWN_CMD             4
